// Generated by CoffeeScript 1.7.1
(function() {
  var BrowserWindow, createGuest, frameToGuest, ipc,
    __slice = [].slice;

  ipc = require('ipc');

  BrowserWindow = require('browser-window');

  frameToGuest = {};

  createGuest = function(embedder, url, frameName, options) {
    var closedByEmbedder, closedByUser, guest;
    guest = frameToGuest[frameName];
    if (frameName && (guest != null)) {
      guest.loadUrl(url);
      return guest.id;
    }
    guest = new BrowserWindow(options);
    guest.loadUrl(url);
    closedByEmbedder = function() {
      guest.removeListener('closed', closedByUser);
      if (!guest.isClosed()) {
        return guest.destroy();
      }
    };
    closedByUser = function() {
      return embedder.removeListener('render-view-deleted', closedByEmbedder);
    };
    embedder.once('render-view-deleted', closedByEmbedder);
    guest.once('closed', closedByUser);
    if (frameName) {
      frameToGuest[frameName] = guest;
      guest.frameName = frameName;
      guest.once('closed', function() {
        return delete frameToGuest[frameName];
      });
    }
    return guest.id;
  };

  ipc.on('ATOM_SHELL_GUEST_WINDOW_MANAGER_WINDOW_OPEN', function() {
    var args, event, frameName, options, url;
    event = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
    url = args[0], frameName = args[1], options = args[2];
    event.sender.emit('-new-window', event, url, frameName, 7);
    if (event.sender.isGuest() || event.defaultPrevented) {
      return event.returnValue = null;
    } else {
      return event.returnValue = createGuest.apply(null, [event.sender].concat(__slice.call(args)));
    }
  });

  ipc.on('ATOM_SHELL_GUEST_WINDOW_MANAGER_WINDOW_CLOSE', function(event, guestId) {
    if (!BrowserWindow.windows.has(guestId)) {
      return;
    }
    return BrowserWindow.windows.get(guestId).destroy();
  });

  ipc.on('ATOM_SHELL_GUEST_WINDOW_MANAGER_WINDOW_METHOD', function() {
    var args, event, guestId, method, _ref;
    event = arguments[0], guestId = arguments[1], method = arguments[2], args = 4 <= arguments.length ? __slice.call(arguments, 3) : [];
    if (!BrowserWindow.windows.has(guestId)) {
      return;
    }
    return (_ref = BrowserWindow.windows.get(guestId))[method].apply(_ref, args);
  });

  ipc.on('ATOM_SHELL_GUEST_WINDOW_MANAGER_WEB_CONTENTS_METHOD', function() {
    var args, event, guestId, method, _ref;
    event = arguments[0], guestId = arguments[1], method = arguments[2], args = 4 <= arguments.length ? __slice.call(arguments, 3) : [];
    if (!BrowserWindow.windows.has(guestId)) {
      return;
    }
    return (_ref = BrowserWindow.windows.get(guestId).webContents) != null ? _ref[method].apply(_ref, args) : void 0;
  });

}).call(this);
